/*
 * Decompiled with CFR 0.152.
 */
package jade.core;

import jade.core.AID;
import jade.core.Agent;
import jade.core.AgentContainerImpl;
import jade.core.BEConnectionManager;
import jade.core.BackEnd;
import jade.core.BackEndManager;
import jade.core.CaseInsensitiveString;
import jade.core.FrontEnd;
import jade.core.GenericCommand;
import jade.core.IMTPException;
import jade.core.LADT;
import jade.core.NameClashException;
import jade.core.NotFoundException;
import jade.core.PostponedException;
import jade.core.ProfileException;
import jade.core.ProfileImpl;
import jade.core.Runtime;
import jade.core.ServiceDescriptor;
import jade.core.ServiceException;
import jade.core.ServiceFinder;
import jade.core.Specifier;
import jade.core.messaging.GenericMessage;
import jade.core.messaging.MessagingService;
import jade.domain.FIPAAgentManagement.InternalError;
import jade.domain.JADEAgentManagement.JADEManagementOntology;
import jade.imtp.leap.FrontEndStub;
import jade.lang.acl.ACLMessage;
import jade.lang.acl.MessageTemplate;
import jade.security.JADESecurityException;
import jade.util.Logger;
import jade.util.leap.ArrayList;
import jade.util.leap.HashMap;
import jade.util.leap.Iterator;
import jade.util.leap.List;
import jade.util.leap.Map;
import jade.util.leap.Properties;
import java.util.StringTokenizer;
import java.util.Vector;

public class BackEndContainer
extends AgentContainerImpl
implements BackEnd {
    public static final String USE_BACKEND_MANAGER = "jade_core_BackEndContainer_usebemanager";
    public static final String RESYNCH = "jade_core_BackEndContainer_resynch";
    public static final String BE_REPLICAS_SIZE = "be-replicas-size";
    public static final Long REPLICA_CHECK_DELAY = new Long(5000L);
    private static final String ADDR_LIST_DELIMITERS = ", \n\t\r";
    private boolean terminating = false;
    private FrontEnd myFrontEnd;
    private BEConnectionManager myConnectionManager;
    private BackEndManager theBEManager;
    private Map agentImages = new HashMap(1);
    private String[] replicasAddresses;
    private Map principals = new HashMap(1);
    private Properties creationProperties;
    private Logger myLogger = Logger.getMyLogger(this.getClass().getName());
    private boolean synchronizing = false;
    private Object frontEndSynchLock = new Object();
    private List fronEndSynchBuffer = new ArrayList();

    private static Properties adjustProperties(Properties pp) {
        pp.setProperty("main", "false");
        if (pp.getProperty("services") == null) {
            pp.setProperty("services", "jade.core.event.NotificationService");
        }
        return pp;
    }

    public BackEndContainer(Properties props, BEConnectionManager cm) throws ProfileException {
        this.myProfile = new ProfileImpl(BackEndContainer.adjustProperties(props));
        this.localAgents = new LADT(1);
        this.creationProperties = props;
        this.myConnectionManager = cm;
    }

    public boolean connect() {
        try {
            String beAddrs;
            if (this.myProfile.getBooleanProperty(USE_BACKEND_MANAGER, false)) {
                this.theBEManager = this.initBEManager();
            }
            if ((beAddrs = this.myProfile.getParameter("beaddrs", null)) != null) {
                this.replicasAddresses = this.parseAddressList(beAddrs);
                this.myProfile.setParameter(BE_REPLICAS_SIZE, Integer.toString(this.replicasAddresses.length));
            }
            Vector agentSpecs = Specifier.parseSpecifierList(this.myProfile.getParameter("agents", null));
            this.myProfile.setParameter("agents", null);
            this.myFrontEnd = this.myConnectionManager.getFrontEnd(this, null);
            this.myLogger.log(Logger.FINE, "BackEnd container " + this.myProfile.getParameter("container-name", null) + " joining the platform ...");
            Runtime.instance().beginContainer();
            boolean connected = this.joinPlatform();
            if (connected) {
                this.myLogger.log(Logger.FINE, "Join platform OK");
                AID amsAID = this.getAMS();
                this.myProfile.setParameter("platform-id", amsAID.getHap());
                String[] addresses = amsAID.getAddressesArray();
                if (addresses != null) {
                    StringBuffer sb = new StringBuffer();
                    int i = 0;
                    while (i < addresses.length) {
                        sb.append(addresses[i]);
                        if (i < addresses.length - 1) {
                            sb.append(';');
                        }
                        ++i;
                    }
                    this.myProfile.setParameter("addresses", sb.toString());
                }
                if ("true".equals(this.myProfile.getParameter(RESYNCH, "false"))) {
                    this.myLogger.log(Logger.INFO, "BackEnd container " + this.myProfile.getParameter("container-name", null) + " re-synching ...");
                    this.resynch();
                } else {
                    int i = 0;
                    while (i < agentSpecs.size()) {
                        Specifier sp = (Specifier)agentSpecs.elementAt(i);
                        try {
                            String name = this.bornAgent(sp.getName());
                            sp.setClassName(name);
                            sp.setArgs(null);
                        }
                        catch (Exception e) {
                            this.myLogger.log(Logger.SEVERE, "Error creating agent " + sp.getName() + ". " + e);
                            sp.setClassName(e.getClass().getName());
                            sp.setArgs(new Object[]{e.getMessage()});
                        }
                        ++i;
                    }
                    this.myProfile.setParameter("agents", Specifier.encodeSpecifierList(agentSpecs));
                }
            }
            return connected;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    protected void startNode() throws IMTPException, ProfileException, ServiceException, JADESecurityException, NotFoundException {
        ArrayList services = new ArrayList();
        ServiceDescriptor dsc = this.startService("jade.core.management.BEAgentManagementService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        dsc = this.startService("jade.core.messaging.MessagingService", false);
        dsc.setMandatory(true);
        services.add(dsc);
        List l = this.myProfile.getSpecifiers("services");
        this.myProfile.setSpecifiers("services", l);
        Iterator serviceSpecifiers = l.iterator();
        while (serviceSpecifiers.hasNext()) {
            Specifier s = (Specifier)serviceSpecifiers.next();
            String serviceClass = s.getClassName();
            boolean isMandatory = false;
            if (s.getArgs() != null) {
                isMandatory = CaseInsensitiveString.equalsIgnoreCase((String)s.getArgs()[0], "true");
            }
            try {
                dsc = this.startService(serviceClass, false);
                dsc.setMandatory(isMandatory);
                services.add(dsc);
            }
            catch (ServiceException se) {
                if (isMandatory) {
                    throw se;
                }
                this.myLogger.log(Logger.WARNING, "Exception initializing service " + serviceClass + " : " + se.toString());
                se.printStackTrace();
            }
        }
        ServiceDescriptor[] descriptors = new ServiceDescriptor[services.size()];
        int i = 0;
        while (i < descriptors.length) {
            descriptors[i] = (ServiceDescriptor)services.get(i);
            ++i;
        }
        if (this.theBEManager != null) {
            this.myNodeDescriptor.setParentNode(this.theBEManager.getNode());
        }
        this.getServiceManager().addNode(this.myNodeDescriptor, descriptors);
        if (this.theBEManager != null) {
            this.theBEManager.register(this.myNodeDescriptor);
        }
        int i2 = 0;
        while (i2 < descriptors.length) {
            ServiceDescriptor currentServDesc = descriptors[i2];
            try {
                currentServDesc.getService().boot(this.myProfile);
            }
            catch (Throwable t) {
                if (currentServDesc.isMandatory()) {
                    throw new ServiceException("An error occurred during service booting", t);
                }
                this.myLogger.log(Logger.WARNING, "Exception booting service " + currentServDesc.getName() + " : " + t.toString());
                t.printStackTrace();
            }
            ++i2;
        }
    }

    public String bornAgent(String name) throws JADESecurityException, IMTPException {
        name = JADEManagementOntology.adjustAgentName(name, new String[]{this.getID().getName()});
        AID id = new AID(name, false);
        GenericCommand cmd = new GenericCommand("Inform-Created", "jade.core.management.AgentManagement", null);
        cmd.addParam(id);
        Object ret = this.myCommandProcessor.processOutgoing(cmd);
        if (ret instanceof NameClashException) {
            throw new JADESecurityException(((NameClashException)ret).getMessage());
        }
        if (ret instanceof JADESecurityException) {
            throw (JADESecurityException)ret;
        }
        if (ret instanceof IMTPException) {
            throw (IMTPException)ret;
        }
        if (ret instanceof Throwable) {
            throw new IMTPException(null, (Exception)ret);
        }
        return name;
    }

    public void deadAgent(String name) throws IMTPException {
        AID id = new AID(name, false);
        this.handleEnd(id);
    }

    public void suspendedAgent(String name) throws NotFoundException, IMTPException {
        AID id = new AID(name, false);
        this.handleChangedAgentState(id, 2, 4);
    }

    public void resumedAgent(String name) throws NotFoundException, IMTPException {
        AID id = new AID(name, false);
        this.handleChangedAgentState(id, 4, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void messageOut(ACLMessage msg, String sender) throws NotFoundException, IMTPException {
        AID id = new AID(sender, false);
        AgentImage image = null;
        Object object = this.frontEndSynchLock;
        synchronized (object) {
            image = (AgentImage)this.agentImages.get(id);
            if (image == null) {
                if (this.synchronizing) {
                    this.postponeAfterFrontEndSynch(msg, sender);
                    return;
                }
                throw new NotFoundException("No image for agent " + sender + " on the BackEndContainer");
            }
        }
        this.handleSend(msg, id, false);
    }

    public void createAgentOnFE(String name, String className, String[] args) throws IMTPException {
        if (!this.isMaster()) {
            throw new IMTPException("This is not the active back-end replica.");
        }
        this.myFrontEnd.createAgent(name, className, args);
    }

    public void killAgentOnFE(String name) throws IMTPException, NotFoundException {
        if (!this.isMaster()) {
            throw new IMTPException("This is not the active back-end replica.");
        }
        try {
            this.myFrontEnd.killAgent(name);
        }
        catch (PostponedException pe) {
            this.deadAgent(name);
        }
    }

    public void suspendAgentOnFE(String name) throws IMTPException, NotFoundException {
        if (!this.isMaster()) {
            throw new IMTPException("This is not the active back-end replica.");
        }
        try {
            this.myFrontEnd.suspendAgent(name);
        }
        catch (PostponedException pe) {
            this.suspendedAgent(name);
        }
    }

    public void resumeAgentOnFE(String name) throws IMTPException, NotFoundException {
        if (!this.isMaster()) {
            throw new IMTPException("This is not the active back-end replica.");
        }
        try {
            this.myFrontEnd.resumeAgent(name);
        }
        catch (PostponedException pe) {
            this.resumedAgent(name);
        }
    }

    public boolean postMessageToLocalAgent(ACLMessage msg, AID receiverID) {
        boolean found = super.postMessageToLocalAgent(msg, receiverID);
        if (found) {
            return found;
        }
        AgentImage image = (AgentImage)this.agentImages.get(receiverID);
        if (image != null) {
            if (this.agentImages.containsKey(msg.getSender())) {
                return true;
            }
            try {
                if (this.isMaster()) {
                    this.myFrontEnd.messageIn(msg, receiverID.getLocalName());
                    this.handlePosted(receiverID, msg);
                    return true;
                }
                System.out.println("WARNING: Trying to deliver a message through a replica");
                return false;
            }
            catch (NotFoundException nfe) {
                System.out.println("WARNING: Missing agent in FrontEnd");
                return false;
            }
            catch (IMTPException imtpe) {
                System.out.println("WARNING: Can't deliver message to FrontEnd");
                return false;
            }
        }
        System.out.println("WARNING: Agent " + receiverID + " not found on BackEnd container");
        return false;
    }

    public Agent acquireLocalAgent(AID id) {
        Agent ag = super.acquireLocalAgent(id);
        if (ag == null) {
            ag = (Agent)this.agentImages.get(id);
        }
        return ag;
    }

    public void releaseLocalAgent(AID id) {
        super.releaseLocalAgent(id);
    }

    public AID[] agentNames() {
        AID[] realAgents = super.agentNames();
        AID[] images = this.getAgentImages();
        AID[] all = new AID[realAgents.length + images.length];
        int i = 0;
        while (i < realAgents.length) {
            all[i] = realAgents[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < images.length) {
            all[i2 + realAgents.length] = images[i2];
            ++i2;
        }
        return all;
    }

    public void enableDebugger(AID debuggerName, AID toBeDebugged) throws IMTPException {
        throw new IMTPException("Unsupported operation");
    }

    public void disableDebugger(AID debuggerName, AID notToBeDebugged) throws IMTPException {
        throw new IMTPException("Unsupported operation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown() {
        BackEndContainer backEndContainer = this;
        synchronized (backEndContainer) {
            if (this.terminating) {
                return;
            }
            this.terminating = true;
        }
        this.stopReplicaMonitor();
        try {
            if (this.isMaster()) {
                this.myFrontEnd.exit(false);
            }
        }
        catch (IMTPException imtpe) {
            this.myConnectionManager.shutdown();
        }
        this.killAgentImages();
        if (this.theBEManager != null) {
            this.theBEManager.deregister(this.myNodeDescriptor);
        }
        super.shutDown();
    }

    private void killAgentImages() {
        AID[] ids = this.getAgentImages();
        int i = 0;
        while (i < ids.length) {
            this.handleEnd(ids[i]);
            ++i;
        }
        if (this.agentImages.size() > 0) {
            this.myLogger.log(Logger.WARNING, "# " + this.agentImages.size() + " zombie agent images found.");
            this.agentImages.clear();
        }
    }

    public void activateReplicas() {
        this.creationProperties.setProperty("be-base-name", this.getID().getName());
        Properties newProps = (Properties)this.creationProperties.clone();
        newProps.setProperty("master-node-name", this.getID().getName());
        if (this.replicasAddresses != null) {
            int i = 0;
            while (i < this.replicasAddresses.length) {
                try {
                    newProps.setProperty("container-name", this.getID().getName() + "-Replica-" + (i + 1));
                    newProps.setProperty("be-replica-index", Integer.toString(i + 1));
                    this.myConnectionManager.activateReplica(this.replicasAddresses[i], newProps);
                }
                catch (IMTPException imtpe) {
                    System.out.println("--- Replica activation failed [" + this.replicasAddresses[i] + "] ---");
                }
                ++i;
            }
        }
    }

    public void restartReplica(int index) throws IMTPException {
        Properties newProps = (Properties)this.creationProperties.clone();
        String baseName = this.creationProperties.getProperty("be-base-name");
        String masterNodeName = this.getMasterName();
        if (masterNodeName == null) {
            masterNodeName = this.getID().getName();
        }
        newProps.setProperty("master-node-name", masterNodeName);
        if (index == 0) {
            String replicaZeroAddr = this.creationProperties.getProperty("be-replica-zero-address");
            newProps.setProperty("container-name", baseName);
            newProps.setProperty("be-replica-index", "0");
            this.myConnectionManager.activateReplica(replicaZeroAddr, newProps);
        } else {
            newProps.setProperty("container-name", baseName + "-Replica-" + index);
            newProps.setProperty("be-replica-index", Integer.toString(index));
            this.myConnectionManager.activateReplica(this.replicasAddresses[index - 1], newProps);
        }
    }

    public void becomeMaster() {
        if (this.isMaster()) {
            return;
        }
        GenericCommand cmd1 = new GenericCommand("Become-Master", "jade.core.replication.BEReplication", null);
        this.myCommandProcessor.processOutgoing(cmd1);
        AID[] imgs = this.getAgentImages();
        int i = 0;
        while (i < imgs.length) {
            String name = imgs[i].getLocalName();
            try {
                this.bornAgent(name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    public boolean isMaster() {
        GenericCommand cmd = new GenericCommand("Is-Master", "jade.core.replication.BEReplication", null);
        this.myCommandProcessor.processOutgoing(cmd);
        Object result = cmd.getReturnValue();
        if (result instanceof Boolean) {
            return (Boolean)result;
        }
        return result == null;
    }

    public String getMasterName() {
        GenericCommand cmd = new GenericCommand("Get-Master-Name", "jade.core.replication.BEReplication", null);
        this.myCommandProcessor.processOutgoing(cmd);
        Object result = cmd.getReturnValue();
        if (result instanceof String) {
            return (String)result;
        }
        return null;
    }

    private void stopReplicaMonitor() {
        GenericCommand cmd = new GenericCommand("Stop-Monitor", "jade.core.replication.BEReplication", null);
        this.myCommandProcessor.processOutgoing(cmd);
    }

    private String[] parseAddressList(String toParse) {
        StringTokenizer lexer = new StringTokenizer(toParse, ADDR_LIST_DELIMITERS);
        ArrayList addresses = new ArrayList();
        while (lexer.hasMoreTokens()) {
            String tok = lexer.nextToken();
            addresses.add(tok);
        }
        Object[] objs = addresses.toArray();
        String[] result = new String[objs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (String)objs[i];
            ++i;
        }
        return result;
    }

    private BackEndManager initBEManager() {
        try {
            return BackEndManager.getInstance(null);
        }
        catch (Exception e) {
            this.myLogger.log(Logger.WARNING, "Cannot retrieve BackEndManager. " + e);
            e.printStackTrace();
            return null;
        }
    }

    public AgentImage createAgentImage(AID id) {
        return new AgentImage(id);
    }

    public AgentImage addAgentImage(AID id, AgentImage img) {
        return (AgentImage)this.agentImages.put(id, img);
    }

    public AgentImage removeAgentImage(AID id) {
        AgentImage img = (AgentImage)this.agentImages.remove(id);
        this.removePendingMessages(MessageTemplate.MatchReceiver(new AID[]{id}), true);
        return img;
    }

    public AgentImage getAgentImage(AID id) {
        return (AgentImage)this.agentImages.get(id);
    }

    public AID[] getAgentImages() {
        Object[] objs = this.agentImages.keySet().toArray();
        AID[] result = new AID[objs.length];
        int i = 0;
        while (i < result.length) {
            result[i] = (AID)objs[i];
            ++i;
        }
        return result;
    }

    public List removePendingMessages(MessageTemplate template, boolean notifyFailure) {
        List pendingMsg = ((FrontEndStub)this.myFrontEnd).removePendingMessages(template);
        if (pendingMsg.size() > 0) {
            this.myLogger.log(Logger.INFO, "Removed " + pendingMsg.size() + " pending messages from BackEnd queue.");
        }
        if (notifyFailure) {
            Iterator it = pendingMsg.iterator();
            while (it.hasNext()) {
                try {
                    Object[] removed = (Object[])it.next();
                    ACLMessage msg = (ACLMessage)removed[0];
                    AID receiver = new AID((String)removed[1], false);
                    ServiceFinder myFinder = this.getServiceFinder();
                    MessagingService msgSvc = (MessagingService)myFinder.findService("jade.core.messaging.Messaging");
                    msgSvc.notifyFailureToSender(new GenericMessage(msg), receiver, new InternalError("Agent dead"));
                }
                catch (Exception e) {
                    this.myLogger.log(Logger.WARNING, "Cannot send AMS FAILURE. " + e);
                }
            }
        }
        return pendingMsg;
    }

    private void resynch() {
        this.synchronizing = true;
        Thread synchronizer = new Thread(){

            public void run() {
                while (!BackEndContainer.this.terminating) {
                    try {
                        BackEndContainer.this.myFrontEnd.synch();
                        BackEndContainer.this.notifySynchronized();
                        BackEndContainer.this.myLogger.log(Logger.INFO, "Resynch completed");
                        break;
                    }
                    catch (IMTPException imtpe) {
                        if (BackEndContainer.this.myLogger.isLoggable(Logger.FINE)) {
                            BackEndContainer.this.myLogger.log(Logger.FINE, "Can't issue SYNCH command to FE. Wait a bit and retry...");
                        }
                        try {
                            Thread.sleep(1000L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
        };
        synchronizer.start();
    }

    private void postponeAfterFrontEndSynch(ACLMessage msg, String sender) {
        this.fronEndSynchBuffer.add(new MessageSenderPair(msg, sender));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifySynchronized() {
        Object object = this.frontEndSynchLock;
        synchronized (object) {
            Iterator it = this.fronEndSynchBuffer.iterator();
            while (it.hasNext()) {
                try {
                    MessageSenderPair msp = (MessageSenderPair)it.next();
                    this.messageOut(msp.getMessage(), msp.getSender());
                }
                catch (NotFoundException nfe) {
                    nfe.printStackTrace();
                }
                catch (IMTPException imtpe) {
                    imtpe.printStackTrace();
                }
            }
            this.fronEndSynchBuffer.clear();
            this.synchronizing = false;
        }
    }

    private class MessageSenderPair {
        private ACLMessage msg;
        private String sender;

        private MessageSenderPair(ACLMessage msg, String sender) {
            this.msg = msg;
            this.sender = sender;
        }

        private ACLMessage getMessage() {
            return this.msg;
        }

        private String getSender() {
            return this.sender;
        }
    }

    public class AgentImage
    extends Agent {
        private AgentImage(AID id) {
            super(id);
            this.setToolkit(BackEndContainer.this);
        }
    }
}

